/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于获取控制芯片列表/显示芯片列表/行管芯片列表
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.11.21
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported get_side_data */
/* exported mc_main_get_hardware_cnt */
/* exported mc_box_main_select_mod */
/* exported mc_after_onload */
/* exported mc_main_updata_screen_data_box_name */
/* exported mc_main_box_template_save */
/* exported mc_main_box_template_param */
/* exported mc_main_box_template_param_list */
/* exported mc_set_mod */

/* global $ */
/* global mc_sdk_param */
/* global mc_ui_box */
/* global mc_sdk_get_box_base */
/* global mc_sdk_get_reg */
/* global mc_sdk_get_reg_list */
/* global mc_sdk_send_box_perstore */
/* global mc_sdk_send_memory_box_base */
/* global mc_sdk_send_box_presave */
// /* global mc_load_msg_update_data */
/* global mc_loading_wait */
/* global mc_main_alert_popout */
/* global mc_loading_wait_remove */
/* global mc_layout_get_box_basic */
/* global mc_crypto_set_box_md5_to_key */
/* global mc_gamma_get_gamma */
/* global mc_layout_get_box_size */
/* global mc_sdk_hub */
/* global mc_sdk_get_recvcard_hub_file */
/* global mc_sdk_get_box_tplparam */
/* global mc_normal_get_pamtlist_by_sdk */
/* global mc_sdk_apply_box */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    字符串截取
 * 参数:
 *    @param {Promise<string>} str_param 处理参数
 *    @param {Promise<string>} str_way 处理方式
 * 返回：
 *    @return {Promise<Array>} 截取后生成的数组;
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.11.21
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_splice_str(str_param, str_way) {
    if ("string" !== typeof str_param || 0 >= str_param.length) {
        return [];
    }
    if (-1 === str_param.indexOf(str_way)) {
        return [str_param];
    }
    return str_param.split(str_way);
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    读取硬件连接状态
 * 参数:
 *    @param {Promise<string>} str_hardware_res 硬件连接信息
 * 返回：
 *     @returns {Promise<string>} 硬件链接状态
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.1.9
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_get_hardware_cnt(str_hardware_res) {
    if ("string" !== typeof str_hardware_res || 0 >= str_hardware_res.length) {
        return false;
    }
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_json(str_hardware_res);
    var ui_param_cnt = obj_sdk_param.get_param_cnt();

    if (0 >= ui_param_cnt) {
        return false;
    }
    var str_hw_state = "";

    for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
        var str_param_name = obj_sdk_param.get_param_name(idx_param);
        var str_attr_value = obj_sdk_param.get_attr_val(str_param_name, "ETH_STATUS");

        if ("ERROR_CODE" === str_param_name) {
            continue;
        }
        if (!str_attr_value) {
            str_hw_state += "[NA],";
            continue;
        }
        var str_hardware = "[";
        var ary_cnt = mc_main_splice_str(str_attr_value, ",");

        for (var idx_cnt = 0; idx_cnt < ary_cnt.length; idx_cnt++) {
            var ui_status = ary_cnt[idx_cnt];

            ui_status = mc_main_splice_str(ui_status, ":");
            if (16 !== ui_status.length || -1 === ui_status[0].indexOf("(")) {
                str_hardware += "NA,";
                continue;
            }
            ui_status = Number(ui_status[2]) + Number(ui_status[0].split("(")[1]);
            str_hardware += ui_status + ",";
        }
        str_hardware = str_hardware.substring(0, str_hardware.length - 1) + "]";
        str_hw_state += str_hardware + ",";
    }
    return str_hw_state.substring(0, str_hw_state.length - 1);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    加载配置信息
 * 参数:
 *    @param {Promise<string>} str_ui_box ui_box文件
 *    @param {Promise<string>} ary_box_data 箱体链接数据
 *    @param {Promise<string>} ary_mod_data 模组数据
 * 返回：
 *     @returns {Promise<boolean>} 函数执行结果
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.1.9
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_trans_ui_box_xml(str_ui_box, ary_box_data, ary_mod_data) {
    if (!Array.isArray(ary_box_data)) {
        return 0;
    }
    if (!Array.isArray(ary_mod_data)) {
        return 0;
    }
    // 创建箱体
    var obj_ui_box = new mc_ui_box();
    // 存入载入数据,获取载入结果
    var ui_error_code = obj_ui_box.mc_util_set_box_xml(str_ui_box);

    // 设置箱体为存入状态
    obj_ui_box.mc_util_set_box_is_set();

    if ("number" === typeof ui_error_code) {
        return ui_error_code;
    }

    var obj_window = window;

    while (true) {
        if (obj_window.g_obj_corr_rapid_data && obj_window.g_str_show_light_data) {
            // 获取页面矫正 及 显示控制参数
            obj_window.g_obj_corr_rapid_data = obj_ui_box.mc_util_get_correct_msg();
            obj_window.g_str_show_light_data = obj_ui_box.mc_util_get_restore();
            break;
        } else {
            obj_window = parent;
        }
    }

    // 建立箱体数据
    var obj_box_data = {};
    var str_box_name = "";
    var ui_box_len_max = -1;

    for (var idx_box_name = 0; idx_box_name < ary_box_data.length; idx_box_name++) {
        str_box_name = ary_box_data[idx_box_name].name;
        var ui_box_len = Number(str_box_name.match(/\d+/g)[0]);

        if (ui_box_len > ui_box_len_max) {
            ui_box_len_max = ui_box_len;
        }
    }
    // 存入箱体名称
    obj_box_data.name = "MC_BOX_" + (ui_box_len_max + 1);

    // 为常规参数增加错误码根据亮度有效率是否异常设置-1 / 0
    var obj_param_ui = obj_ui_box.mc_util_get_resul();
    var ui_lumi_effict = Number(obj_param_ui.get_param_value("LUMI_EFFICT"));

    obj_param_ui.set_param_value("ERROR_CODE", "-1");
    if (!isNaN(ui_lumi_effict) && 0.000001 < ui_lumi_effict) {
        obj_param_ui.set_param_value("ERROR_CODE", "0");
    }
    // 存入模组
    var ui_mod_cnt = obj_ui_box.mc_util_get_mod_cnt();
    var ui_mod_idx_max = -1;

    // 获取最大模组名称
    for (var idx_mod_idx = 0; idx_mod_idx < ary_mod_data.length; idx_mod_idx++) {
        var str_mod_name_idx = ary_mod_data[idx_mod_idx].name.match(/\d+/g)[0];

        if (ui_mod_idx_max < Number(str_mod_name_idx)) {
            ui_mod_idx_max = Number(str_mod_name_idx);
        }
    }

    // 判断模组是否存在,使用存在模组名称替换箱体内使用模组名称
    for (var idx_mod = 0; idx_mod < ui_mod_cnt; idx_mod++) {
        ui_mod_idx_max++;

        var obj_mod_data = {
            name: "MC_MOD_" + (ui_mod_idx_max)
        };
        var str_mod_name = obj_ui_box.mc_util_get_mod_name_by_idx(idx_mod);
        var obj_mod_data_loc = obj_ui_box.mc_util_get_mod_data_by_name(str_mod_name);
        var obj_mod_loc = obj_mod_data_loc.module_value;
        var b_is_exist = false;

        for (var idx_mod_loc = 0; idx_mod_loc < ary_mod_data.length; idx_mod_loc++) {
            var str_mod_name_loc = ary_mod_data[idx_mod_loc].name;

            if (obj_mod_loc.mc_util_mod_check_equal(ary_mod_data[idx_mod_loc].data.mc_util_mod_get_xml())) {
                b_is_exist = true;
                obj_mod_data.name = str_mod_name_loc;
                break;
            }
        }
        mc_main_revise_box_mod_name(obj_ui_box, str_mod_name, obj_mod_data.name);
        if (b_is_exist) {
            continue;
        }
        obj_mod_data.data = obj_mod_loc;
        ary_mod_data.push(obj_mod_data);
    }

    obj_ui_box.mc_util_reset(7);

    // 存入mc_sdk_recvcard生成xml描述信息
    obj_box_data.data = obj_ui_box;
    // 存入ctrlchip_hub_msg字串
    // mc_load_msg_update_data(obj_box_data);

    var str_new_box_md5 = mc_crypto_set_box_md5_to_key(obj_box_data);

    for (var idx_box = 0; idx_box < ary_box_data.length; idx_box++) {
        var str_box_md5 = mc_crypto_set_box_md5_to_key(ary_box_data[idx_box]);

        if (str_box_md5 === str_new_box_md5) {
            return ary_box_data[idx_box].name;
        }
    }
    ary_box_data.push(obj_box_data);
    // console.log(obj_box_data.name);
    // console.log(obj_box_data.data.mc_util_get_device_data().get_json());

    return obj_box_data.name;
}

// 将相同的模组名称改为当前的模组名称
function mc_main_revise_box_mod_name(obj_ui_box, str_mod_name_old, str_mod_name_new) {
    if ("string" !== typeof str_mod_name_old || 0 >= str_mod_name_old.length) {
        return;
    }
    if ("string" !== typeof str_mod_name_new || 0 >= str_mod_name_new.length) {
        return;
    }
    var obj_box_msg = obj_ui_box.mc_util_get_ui_box_msg();
    var ary_box_jx_list = obj_box_msg.data;

    for (var idx_list = 0; idx_list < ary_box_jx_list.length; idx_list++) {
        var ary_mod_list = ary_box_jx_list[idx_list].children;

        for (var idx_mod = 0; idx_mod < ary_mod_list.length; idx_mod++) {
            var obj_mod_data = ary_mod_list[idx_mod];
            var str_mod_name = obj_mod_data.module_name;

            if (str_mod_name === str_mod_name_old) {
                obj_mod_data.module_name = str_mod_name_new;
            }
        }
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    建立对应箱体ui_box描述信息  获取寄存器数据 下发预存信息 获取预存信息 下发箱体base
 * 参数:
 *    @param {Promise<string>} box_name 箱体名称
 *    @param {Promise<Array>} ary_box_data 箱体链接数据
 *    @param {Promise<Array>} ary_mod_data 模组数据
 *    @param {Promise<Function>} fn_callback 回调函数
 *    @param {Promise<Object>} obj_transform_param 变换信息参数
 *    @param {Promise<Boolean>} b_get_param 是否更新箱体参数
 *    @param {Promise<Boolean>} b_is_set 是否存入接收卡数据
 *    @param {Promise<Boolean>} b_is_get 是否只是获取xml而不发送 默认false
 * 返回：
 *     NA
 * 备注:
 *     0:参数错误
 *     1:芯片错误
 *     2:分组模式错误
 *     3:引脚错误
 *     4:三线并行颜色错误
 *     5:未知错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.1.9
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_construct_ui_box_xml(box_name, ary_box_data, ary_mod_data, fn_callback, obj_transform_param, b_get_param, b_is_set, b_is_get) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if ("string" !== typeof box_name || 0 >= box_name.length) {
        fn_callback(0);
        return;
    }
    if (!Array.isArray(ary_box_data)) {
        fn_callback(0);
        return;
    }
    if (!Array.isArray(ary_mod_data)) {
        fn_callback(0);
        return;
    }

    var ui_box_idx = mc_main_get_idx_by_name(ary_box_data, box_name);

    if ("number" !== typeof ui_box_idx) {
        fn_callback(0);
        return;
    }
    var obj_ui_box = ary_box_data[ui_box_idx].data;
    var obj_box_msg = obj_ui_box.mc_util_get_ui_box_msg();
    var str_ctrlchip_name = obj_box_msg.ctrlchip_name;
    var str_hub_name = obj_box_msg.hub_name;
    var str_fisrt_mod_name = obj_ui_box.mc_util_get_box_first_mod_name();
    var ui_fist_mod_idx = mc_main_get_idx_by_name(ary_mod_data, str_fisrt_mod_name);
    var obj_first_mod_data = ary_mod_data[ui_fist_mod_idx].data;
    var str_dispchip_name = obj_first_mod_data.mc_util_mod_get_disp_chip();
    var str_scanchip_name = obj_first_mod_data.mc_util_mod_get_scan_chip();
    var obj_res_param = new mc_sdk_param();
    var obj_edit_val = obj_box_msg.edit_val;
    var obj_correct_data = parent.g_obj_corr_rapid_data;
    var str_restore = parent.g_str_show_light_data;
    // 矫正硬件数据
    var obj_hw_gaumt = "";
    // 所有接收卡配置信息
    var obj_box_base = new mc_sdk_param();


    obj_ui_box.mc_util_set_correct_msg(obj_correct_data);
    obj_ui_box.mc_util_set_restore(str_restore);
    if (obj_transform_param) {
        var str_mirror = obj_transform_param.str_mirror.replace(/\(|\)/g, "").replace(/:/g, ",");
        var str_rotation = obj_transform_param.str_rotation.replace(/\(|\)/g, "").replace(/:/g, ",");
        var str_scale = obj_transform_param.str_scale.replace(/\(|\)/g, "").replace(/:/g, ",");
        var str_cut = obj_transform_param.str_cut;

        obj_ui_box.mc_util_set_trans([str_mirror, str_rotation, str_scale,false,str_cut]);
    }
    // 获取hub描述信息 如果已存在hub描述信息则使用已存在的 如果没有则去获取一边默认信息,获取默认信息如果失败则创建默认hub描述信息
    mc_main_get_hub_msg(str_ctrlchip_name, str_hub_name, obj_edit_val, get_hub_msg);

    function get_hub_msg(str_hub_msg) {
        if (!str_hub_msg) {
            if (b_get_param) {
                mc_main_get_reg(str_ctrlchip_name, str_dispchip_name, true, "", get_disp_reg);
            } else {
                mc_set_base();
            }
            return;
        }
        obj_res_param = new mc_sdk_param();
        obj_res_param.set_json(str_hub_msg);
        str_hub_msg = obj_res_param.get_attr_val(str_ctrlchip_name, "DATA");

        var obj_sdk_hub = new mc_sdk_hub();

        obj_sdk_hub.set_hub_xml(str_hub_msg);
        obj_edit_val = obj_sdk_hub.get_hub_msg();

        if (!obj_edit_val.str_name) {
            var ary_defualt_dat = [];

            for (var idx = 0; 256 > idx; idx++) {
                ary_defualt_dat.push(idx);
            }
            obj_edit_val = {
                str_name: str_hub_name,
                str_iccount: "1",
                str_all_use_dat_cnt: "256",
                ary_child_pin: [{
                    str_subname: "A",
                    str_use_dat_pin_count: "256",
                    str_use_ctl_pin_count: "0",
                    str_dat_pin_cnt: "256",
                    ary_st_dat: ary_defualt_dat,
                    ary_st_ctl: []
                }]

            };
        }
        obj_box_msg.edit_val = obj_edit_val;
        mc_main_get_reg(str_ctrlchip_name, str_dispchip_name, true, "", get_disp_reg);
    }

    function get_disp_reg(disp_reg) {
        obj_res_param = new mc_sdk_param();
        obj_res_param.set_json(disp_reg);
        obj_ui_box.mc_util_set_disp_reg(obj_res_param);
        mc_main_get_reg(str_ctrlchip_name, str_scanchip_name, false, "", get_scan_reg);
    }

    function get_scan_reg(scan_reg) {
        obj_res_param = new mc_sdk_param();
        obj_res_param.set_json(scan_reg);
        obj_ui_box.mc_util_set_scan_reg(obj_res_param);
        mc_main_get_reg_list(str_ctrlchip_name, str_dispchip_name, true, "", get_disp_reg_list);
    }

    function get_disp_reg_list(disp_list) {
        obj_res_param = new mc_sdk_param();
        obj_res_param.set_json(disp_list);
        obj_ui_box.mc_util_set_disp_reg_list(obj_res_param);
        mc_main_get_reg_list(str_ctrlchip_name, str_scanchip_name, false, "", get_scan_reg_list);
    }

    function get_scan_reg_list(scan_list) {
        obj_res_param = new mc_sdk_param();
        obj_res_param.set_json(scan_list);
        obj_ui_box.mc_util_set_scan_reg_list(obj_res_param);

        // ARY_BOX_DATA[ui_box_idx].data.mc_util_get_gamma_val()
        if ("undefined" !== typeof ary_box_data[ui_box_idx].data.mc_util_get_gamma_val()) {
            if (0 !== ary_box_data[ui_box_idx].data.mc_util_get_gamma_val().length) {
                get_gamma_callback(ary_box_data[ui_box_idx].data.mc_util_get_gamma_val());
            } else {
                mc_gamma_get_gamma(function (arr) {
                    var obj_box = new mc_sdk_param();

                    obj_box.set_json(ary_box_data[ui_box_idx].ctrlchip_hub_msg);
                    // ary_box_data[ui_box_idx].ctrlchip_name 之前
                    var str_ctrl_name = obj_box.get_param_value("MC_LANG_CTRLCHIP_LIST");

                    var str_gamma_normal = arr.toString();
                    var obj_gamma = {
                        appoint_type_name: "",
                        chart_type_name: "Calculate",
                        data: str_gamma_normal,
                        factor: "2.8",
                        gray_bit: "12",
                        mode_val_idx: "1",
                        type: "0",
                        y_val: "65535",
                        curr_disp_chip: str_dispchip_name,
                        curr_ctrl_chip: str_ctrl_name
                    };
                    var arr_gamma = [obj_gamma];

                    get_gamma_callback(arr_gamma);
                }, "", "", "", "", "");
            }
        } else {
            mc_gamma_get_gamma(function (arr) {
                var str_gamma_normal = arr.toString();
                var obj_gamma = {
                    appoint_type_name: "",
                    chart_type_name: "Calculate",
                    data: str_gamma_normal,
                    factor: "2.8",
                    gray_bit: "12",
                    mode_val_idx: "1",
                    type: "0",
                    y_val: "65535",
                    curr_disp_chip: str_dispchip_name,
                    curr_ctrl_chip: ary_box_data[ui_box_idx].ctrlchip_name
                };
                var arr_gamma = [obj_gamma];

                get_gamma_callback(arr_gamma);
            }, "", "", "", "", "");
        }
    }

    function get_gamma_callback(gama) {
        obj_ui_box.mc_util_set_gamma_val(gama);
        // 下发常规参数 (仅针对操作编辑界面后下发)
        if (parent.G_B_OPERATION_EDIT) {
            parent.G_B_OPERATION_EDIT = false;
            var str_data = ary_box_data[ui_box_idx].data.mc_util_get_param().get_json();

            mc_set_param(str_data, mc_set_base);
        } else {
            mc_set_base();
        }
    }


    function mc_set_base() {
        var ary_jx_list = obj_box_msg.data;
        var ary_mod_list = [];

        for (var idx_list = 0; idx_list < ary_jx_list.length; idx_list++) {
            var ary_jx_mod_list = ary_jx_list[idx_list].children;

            for (var idx_led = 0; idx_led < ary_jx_mod_list.length; idx_led++) {
                var obj_mod_msg = ary_jx_mod_list[idx_led];
                var str_mod_name = obj_mod_msg.module_name;
                var ui_mod_idx = mc_main_get_idx_by_name(ary_mod_data, str_mod_name);

                if (
                    (0 !== ui_mod_idx && !ui_mod_idx) ||
                    -1 !== ary_mod_list.indexOf(str_mod_name)
                ) {
                    continue;
                }
                var obj_mod_data = ary_mod_data[ui_mod_idx];
                var obj_mod_xml = obj_mod_data.data;

                obj_ui_box.mc_util_set_mod(str_mod_name, obj_mod_xml);
                ary_mod_list.push(str_mod_name);
            }
        }
        mc_sdk_get_box_base(box_name, function (str_cfg_base) {
            obj_box_base.set_json(str_cfg_base);
            obj_box_base.set_json(obj_box_base.get_param_value(box_name));

            mc_get_hw_gamut(str_ctrlchip_name, parent.g_obj_corr_rapid_data.arr_tbl_data, function (obj_gaumt) {
                // 处理矫正数据
                obj_hw_gaumt = obj_gaumt;


                // 目前只有mini卡支持
                if ("MINI" === str_ctrlchip_name) {
                    var obj_device_data = mc_merge_device(obj_hw_gaumt, obj_box_base);

                    obj_ui_box.mc_util_set_device_data(obj_device_data);
                } else {
                    obj_ui_box.mc_util_set_device_data(obj_box_base);
                }

                // 特殊处理是否存入计算 ( 大屏计算 )
                if (parent.b_save_screen && parent.b_if_send_congulate_device) {
                    // 保存对应计算后的参数 不用请求回来的
                    var arr_congulate_device = Object.keys(parent.obj_congulate_device_data);

                    if (0 !== arr_congulate_device.length) {
                        var obj_device = parent.obj_congulate_device_data;

                        for (var key in obj_device) {
                            if (obj_device.hasOwnProperty.call(obj_device, key)) {
                                if (key === box_name) {
                                    obj_ui_box.mc_util_set_device_data(obj_device[key]);
                                }
                            }
                        }
                    }
                }


                var str_ui_box = obj_ui_box.mc_get_ui_box_xml_by_version(1);

                // console.log(str_ui_box);

                if ("string" !== typeof str_ui_box || b_is_get) {
                    fn_callback(str_ui_box);
                    return;
                }
                mc_sdk_send_box_perstore(box_name, str_ui_box, function () {
                    obj_ui_box.mc_util_set_box_change();
                    mc_sdk_get_box_base(box_name, function (str_set_base_msg) {
                        if (!b_is_set) {
                            var obj_set_box_base = new mc_sdk_param();

                            obj_set_box_base.set_json(str_set_base_msg);
                            obj_set_box_base.set_json(obj_set_box_base.get_param_value(box_name));

                            // 目前只有mini卡支持
                            if ("MINI" === str_ctrlchip_name) {
                                var obj_set_device_base = mc_merge_device(obj_hw_gaumt, obj_set_box_base);

                                obj_ui_box.mc_util_set_device_data(obj_set_device_base);
                            } else {
                                obj_ui_box.mc_util_set_device_data(obj_set_box_base);
                            }

                            // 特殊处理是否存入计算 ( 大屏计算 )
                            if (parent.b_save_screen && parent.b_if_send_congulate_device) {
                                // 保存对应计算后的参数 不用请求回来的
                                var arr_congulate_device_nd = Object.keys(parent.obj_congulate_device_data);

                                if (0 !== arr_congulate_device_nd.length) {
                                    var obj_device_nd = parent.obj_congulate_device_data;

                                    for (var key_nd in obj_device_nd) {
                                        if (obj_device_nd.hasOwnProperty.call(obj_device_nd, key_nd)) {
                                            if (key_nd === box_name) {
                                                obj_ui_box.mc_util_set_device_data(obj_device_nd[key_nd]);
                                            }
                                        }
                                    }
                                }
                            }

                            // console.log(box_name);
                            // console.log(obj_ui_box.mc_util_get_device_data().get_json());
                            var ary_box_size = mc_layout_get_box_size(box_name, ary_box_data, ary_mod_data);

                            obj_ui_box.mc_util_set_box_size(ary_box_size[0], ary_box_size[1]);
                            str_ui_box = obj_ui_box.mc_get_ui_box_xml_by_version(1);
                            obj_ui_box.mc_util_reset(7);
                            // obj_ui_box.mc_util_reset(9);
                            obj_ui_box.mc_util_reset(10);
                            obj_ui_box.mc_util_reset(11);
                            fn_callback(str_ui_box);
                        } else {
                            obj_ui_box.mc_util_reset(7);
                            // obj_ui_box.mc_util_reset(9);
                            obj_ui_box.mc_util_reset(10);
                            obj_ui_box.mc_util_reset(11);
                            fn_callback();
                        }
                    }, obj_transform_param);
                }, obj_transform_param);
            });
        }, obj_transform_param);
    }
}
// 获取默认寄存器或已知寄存器
function mc_main_get_reg(str_ctrlchip_name, str_chip_name, b_chipname_type, str_chip_reg, fn_callback) {
    if ("string" === typeof str_chip_reg && 0 < str_chip_reg.length) {
        fn_callback(str_chip_reg);
        return;
    }
    mc_sdk_get_reg(str_ctrlchip_name, str_chip_name, b_chipname_type, function (reg_msg) {
        var obj_sdk_param = new mc_sdk_param();

        obj_sdk_param.set_json(reg_msg);
        fn_callback(obj_sdk_param.get_param_value(str_chip_name));
    });
}
// 获取默认寄存器列表或已知寄存器列表
function mc_main_get_reg_list(str_ctrlchip_name, str_chip_name, b_chipname_type, str_chip_reg_list, fn_callback) {
    if ("string" === typeof str_chip_reg_list && 0 < str_chip_reg_list.length) {
        fn_callback(str_chip_reg_list);
        return;
    }
    mc_sdk_get_reg_list(str_ctrlchip_name, str_chip_name, b_chipname_type, function (reg_list) {
        var obj_sdk_param = new mc_sdk_param();

        obj_sdk_param.set_json(reg_list);
        fn_callback(obj_sdk_param.get_param_value(str_chip_name));
    });
}

// 获取hub描述信息
function mc_main_get_hub_msg(str_ctrlchip_name, str_hub_name, obj_edit_val, fn_callback) {
    if (obj_edit_val && "string" === typeof obj_edit_val.str_name && 0 < obj_edit_val.str_name.length) {
        fn_callback("");
        return;
    }
    mc_sdk_get_recvcard_hub_file(str_ctrlchip_name, str_hub_name, fn_callback);
    return;
}

// 下发常规参数
function mc_set_param(str_data, fn_callback) {
    if ("string" !== typeof str_data || 0 >= str_data.length) {
        fn_callback();
        return;
    }
    var obj_req_sdk = new mc_sdk_req_mgr();

    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_json(str_data);
    obj_sdk_param.set_func("NORMAL");
    obj_sdk_param.set_cmd("SET_PARAM");

    obj_req_sdk.push_req(obj_sdk_param.get_json(), fn_callback);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    根据名称获取箱体或模组对应下标
 * 参数:
 *    @param {Promise<Array>} ary_data 储存模组或箱体的数组
 *    @param {Promise<string>} str_name 查询名称
 * 返回：
 *    @return {Promise<uint>} 对应名称所在下标
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_get_idx_by_name(ary_data, str_name) {
    if (!Array.isArray(ary_data) || 0 >= ary_data.length) {
        return false;
    }
    if ("string" !== typeof str_name || 0 >= str_name.length) {
        return false;
    }
    var ui_idx = 0;

    for (var idx = 0; idx < ary_data.length; idx++) {
        if (!ary_data[idx].name) {
            return false;
        }
        if (ary_data[idx].name === str_name) {
            ui_idx = idx;
            break;
        }
    }
    return ui_idx;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    将屏幕信息中的箱体名称更新为置顶名称
 * 参数:
 *    @param {Promise<Array>} ary_screen_data 屏幕信息
 *    @param {Promise<string>} str_old_box_name 需要更新名称
 *    @param {Promise<string>} str_updata_box_name 更新名称
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.9.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_updata_screen_data_box_name(ary_screen_data, str_old_box_name, str_updata_box_name) {
    if (
        (!Array.isArray(ary_screen_data) || 0 >= ary_screen_data.length) ||
        ("string" !== typeof str_old_box_name || 0 >= str_old_box_name.length) ||
        ("string" !== typeof str_updata_box_name || 0 >= str_updata_box_name.length)
    ) {
        return;
    }


    for (var idx_list = 0; idx_list < ary_screen_data.length; idx_list++) {
        // 单个数据对象
        var obj_data = ary_screen_data[idx_list];
        // 当前数据
        var str_name_val = obj_data.NAME;
        // 下级数据列表
        var ary_chip_list = obj_data.CHILD;

        if (obj_data.CHIP_NAME) {
            var str_box_name = obj_data.box_name;

            if (str_old_box_name === str_box_name) {
                obj_data.box_name = str_updata_box_name;
            }
        } else {
            switch (str_name_val) {
            case "SENDCARD":
                break;
            case "SENDPORT":
                break;
            case "HUB":
                break;
            case "HUBPORT":
                break;
            default:
                return;
            }
            mc_main_updata_screen_data_box_name(ary_chip_list, str_old_box_name, str_updata_box_name);
        }
    }
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    模板参数
 * 参数:
 *    @param {Promise<String>} str_feature_key 匹配模板的key
 *    @param {Promise<String>} str_box_name 箱体名称
 *    @param {Promise<Array>} ary_box_data 箱体数据
 *    @param {Promise<Array>} ary_mod_data 模组数据
 *    @param {Promise<Function>} fn_callback 回调函数
 * 返回：
 *    NA
 * 备注:
 *    0:正常
 *    3:获取内容为空
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.11.12
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_box_template_param(str_feature_key, str_box_name, ary_box_data, ary_mod_data, fn_callback) {
    var ui_box_idx = mc_main_get_idx_by_name(ary_box_data, str_box_name);
    var obj_box_data = ary_box_data[ui_box_idx];

    mc_sdk_get_box_tplparam(str_feature_key, function (str_sdk_res) {
        var obj_sdk_res = new mc_sdk_param();

        obj_sdk_res.set_json(str_sdk_res);
        if ("string" !== typeof obj_sdk_res.get_param_value(str_feature_key)) {
            fn_callback({}, 4);
        }
        var str_dispchip_regitem = obj_sdk_res.get_attr_val(str_feature_key, "DISPCHIP_REGITEM");
        var str_dispchip_reglist_r = obj_sdk_res.get_attr_val(str_feature_key, "DISPCHIP_REGLIST_R");
        var str_dispchip_reglist_g = obj_sdk_res.get_attr_val(str_feature_key, "DISPCHIP_REGLIST_G");
        var str_dispchip_reglist_b = obj_sdk_res.get_attr_val(str_feature_key, "DISPCHIP_REGLIST_B");
        var str_gama_r = obj_sdk_res.get_attr_val(str_feature_key, "GAMA_R");
        var str_normal = obj_sdk_res.get_attr_val(str_feature_key, "NORMAL");
        var str_scanchip_regitem = obj_sdk_res.get_attr_val(str_feature_key, "SCANCHIP_REGITEM");
        var str_scanchip_reglist = obj_sdk_res.get_attr_val(str_feature_key, "SCANCHIP_REGLIST");

        obj_box_data.data.mc_util_set_gamma_val([{
            data: str_gama_r
        }]);
        obj_box_data.data.mc_util_get_disp_reg().set_json(str_dispchip_regitem);
        obj_box_data.data.mc_util_get_scan_reg().set_json(str_scanchip_regitem);
        obj_box_data.data.mc_util_get_scan_reg_list().set_json(str_scanchip_reglist);
        obj_box_data.data.mc_util_get_disp_reg_list().set_param_clear();
        obj_box_data.data.mc_util_get_disp_reg_list().set_param_value("REGLIST_R", str_dispchip_reglist_r);
        obj_box_data.data.mc_util_get_disp_reg_list().set_param_value("REGLIST_G", str_dispchip_reglist_g);
        obj_box_data.data.mc_util_get_disp_reg_list().set_param_value("REGLIST_B", str_dispchip_reglist_b);
        mc_sdk_apply_box(str_box_name, ary_box_data, ary_mod_data, function () {
            mc_normal_get_pamtlist_by_sdk(str_box_name, ary_box_data, ary_mod_data, JSON.parse(str_normal), fn_callback);
        }, 1);
    });
}

/********** EXPORT API *********************************************************************************/
/* exported mc_main_load_msg */
/* exported mc_main_construct_ui_box */
/* exported mc_main_set_box_data_to_send */
/**=
 * @param {String} str_ui_box ui_box识别字串
 * @param {Array} ary_box_data 储存箱体数据数组
 * @param {Array} ary_mod_data 储存模组数据数组
 * @returns {Promise<Function>} 加载配置功能
 */
function mc_main_load_msg(str_ui_box, ary_box_data, ary_mod_data) {
    return mc_main_trans_ui_box_xml(str_ui_box, ary_box_data, ary_mod_data);
}
/**
 * @param {String} box_name 箱体名称
 * @param {Array} ary_box_data 储存箱体数据数组
 * @param {Array} ary_mod_data 储存模组数据数组
 * @param {Array} fn_callback 回调函数(需要保存的子串)
 * @param {Object} obj_transform_param 变换信息参数对象
 * @param {Promise<Boolean>} b_get_param 是否更新箱体参数
 * @param {Promise<Boolean>} b_is_set 是否存入接收卡数据
 * @param {Promise<Boolean>} b_is_get 是否只获取xml不发送
 * @returns {Promise<Function>} 保存配置功能
 */
function mc_main_construct_ui_box(box_name, ary_box_data, ary_mod_data, fn_callback, obj_transform_param, b_get_param, b_is_set, b_is_get) {
    return mc_main_construct_ui_box_xml(box_name, ary_box_data, ary_mod_data, fn_callback, obj_transform_param, b_get_param, b_is_set, b_is_get);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取侧边箱体模组信息
 * 参数:
 *    @param {Promise<Array>} ary_data 储存箱体/模组的数组
 *    @param {Promise<String>} str_data_name 需要获取箱体/模组数据的箱体名称
 * 返回：
 *    @returns {Promise<Object>}
 *     {..} 获取成功
 *     false 参数有误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.04.30
 *      内容 : 所有代码
 ************************************************************************************************/
function get_side_data(ary_data, str_data_name) {
    if (!Array.isArray(ary_data) || 0 === ary_data.length || "string" !== typeof str_data_name) {
        return false;
    }
    var obj_box_data = {};

    for (var idx = 0; idx < ary_data.length; idx++) {
        var str_name = ary_data[idx].name;

        if (str_name === str_data_name) {
            obj_box_data = ary_data[idx];
            break;
        }
    }
    if ({} === obj_box_data) {
        return false;
    }
    return obj_box_data;
}

/* *************************************** HW_PLACE_API **************************************************************************************** */
/* exported mc_main_send_select_list */
/* exported mc_main_send_place */
/* exported mc_main_presave_place */
/* exported mc_main_send_select_update */

/**
 * @param {string} str_show_option  当前界面需要显示的选项
 * @param {Boolean} b_is_presave 回读按钮进入(回读按钮进入/固化或发送按钮进入 = true / false)
 * @param {Boolean} b_hw_relate 是否硬件相关
 * @param {Object} obj_hw_data 硬件连接状态实例函数 暂时改为写死 false 不硬件相关
 * @param {String} str_cur_ctrl_card 当前主控芯片名称
 * @param {Function} fn_callback 回调函数(选择框内容)
 * @param {Boolean} b_open_sendcard 是否显示发送卡
 * @returns {Promise<Function>} 发送选择框
 */
function mc_main_send_select_list(str_show_option, b_is_presave, b_hw_relate, obj_hw_data, str_cur_ctrl_card, fn_callback, b_open_sendcard) {
    return mc_main_send_select(str_show_option, b_is_presave, b_hw_relate, obj_hw_data, str_cur_ctrl_card, fn_callback, b_open_sendcard);
}
/**
 * @param {String} str_show_option 展示显示的项
 * @param {Boolean} b_is_presave 回读按钮进入(回读按钮进入/固化或发送按钮进入 = true / false)
 * @param {Boolean} b_hw_relate 是否硬件相关
 * @param {String} str_ui_json 页面数据
 * @param {Object} obj_hw_data 硬件连接状态实例函数 暂时改为写死 false 不硬件相关
 * @param {Function} fn_callback 回调函数(选择框内容)
 * @returns {Promise<Function>} 发送选择框
 */
function mc_main_send_select_update(str_show_option, b_is_presave, b_hw_relate, str_ui_json, obj_hw_data, fn_callback) {
    return mc_main_update_select(str_show_option, b_is_presave, b_hw_relate, str_ui_json, obj_hw_data, fn_callback);
}

/**
 * 发送 固化
 * @param {String} str_box_name 箱体名称
 * @param {Array} ary_box_data 箱体数据数组
 * @param {Array} ary_mod_data 模组数据数组
 * @param {Array} g_b_lod_box_state 加载数是否改动标识
 * @param {String} str_send_json 页面字串 "all"
 * @param {String} str_order 命令 (可能存在 取决于 str_send_json)
 * @param {String} str_cur_ctrl_card 芯片名称
 * @param {boolean} b_mentype 数据类型; MEMTYPE值; true = "RAM" || false = "FLS"
 * @param {Function} fn_callback 执行结束后回调函数
 * @param {Object} obj_transform_param 变换参数对象
 * @param {Boolean} b_get_param 是否更新箱体信息
 * @param {String} str_workmode 工作模式参数
 * @param {Boolean} b_unsend_base 不发送箱体base/GAMMA/色域/亮度
 */
function mc_main_send_place(str_box_name, ary_box_data, ary_mod_data, g_b_lod_box_state, str_send_json, str_order, str_cur_ctrl_card, b_mentype, fn_callback, obj_transform_param, b_get_param, str_workmode, b_unsend_base) {
    if ("function" !== typeof fn_callback) {
        return;
    }

    var basic_date_val = str_order;

    // if ("all" === str_send_json) {
    //     basic_date_val = str_order;
    // }

    if ("string" !== typeof basic_date_val) {
        fn_callback(basic_date_val);
        return;
    }
    var ui_box_idx = mc_main_get_idx_by_name(ary_box_data, str_box_name);
    var obj_box_data = ary_box_data[ui_box_idx].data;

    var b_is_send_box_msg = obj_box_data.mc_util_get_box_change();


    if (!b_is_send_box_msg) {
        if (!b_unsend_base) {
            // var b_is_set_box = obj_box_data.mc_util_get_box_is_set();
            // 重新计算意味着发箱体名称 让sdk底部操作
            if (!parent.b_if_recaculate) {
                var obj_box_base = obj_box_data.mc_util_get_device_data();

                // mc_sdk_send_memory_box_base("SEND_JSON", obj_box_base.get_json(), basic_date_val, b_mentype, str_cur_ctrl_card, function (str) {
                //     mc_get_base_back(str, str_workmode);
                // }, obj_transform_param, str_workmode);
                if (0 !== obj_box_base.get_param_cnt()) {
                    mc_send_base_json(obj_box_base);
                } else {
                    mc_send_base_box_name();
                }
            } else {
                // mc_sdk_send_memory_box_base("BOX_FILE", str_box_name, basic_date_val, b_mentype, str_cur_ctrl_card, function (str) {
                //     mc_get_base_back(str, str_workmode);
                // }, obj_transform_param, str_workmode);
                mc_send_base_box_name();
            }
        } else {
            fn_callback();
        }
        return;
    }
    obj_transform_param.str_workmode = str_workmode ? str_workmode : "0";
    // debugger; 创建新的box下发
    mc_main_construct_ui_box(str_box_name, ary_box_data, ary_mod_data, function () {
        if (!b_unsend_base) {
            var obj_box_base = obj_box_data.mc_util_get_device_data();

            if (!parent.b_if_recaculate) {
                // mc_sdk_send_memory_box_base("SEND_JSON", obj_box_base.get_json(), basic_date_val, b_mentype, str_cur_ctrl_card, function (str) {
                //     mc_get_base_back(str, str_workmode);
                // }, obj_transform_param, str_workmode);
                if (0 !== obj_box_base.get_param_cnt()) {
                    mc_send_base_json(obj_box_base);
                } else {
                    mc_send_base_box_name();
                }
            } else {
                // mc_sdk_send_memory_box_base("BOX_FILE", str_box_name, basic_date_val, b_mentype, str_cur_ctrl_card, function (str) {
                //     mc_get_base_back(str, str_workmode);
                // }, obj_transform_param, str_workmode);
                mc_send_base_box_name();
            }
        } else {
            fn_callback();
        }
    }, obj_transform_param, true, b_unsend_base);

    function mc_send_base_json(obj_box_device) {
        mc_sdk_send_memory_box_base("SEND_JSON", obj_box_device.get_json(), basic_date_val, b_mentype, str_cur_ctrl_card, function (str) {
            mc_get_base_back(str, str_workmode);
        }, obj_transform_param, str_workmode);
    }
    function mc_send_base_box_name() {
        mc_sdk_send_memory_box_base("BOX_FILE", str_box_name, basic_date_val, b_mentype, str_cur_ctrl_card, function (str) {
            mc_get_base_back(str, str_workmode);
        }, obj_transform_param, str_workmode);
    }

    function mc_get_base_back(str, s_workmode) {
        // parent.mc_main_send_supplenment(str_box_name, ary_box_data, str_order, b_mentype, str_cur_ctrl_card, function () {
        var obj_send_date = new mc_sdk_param();

        obj_send_date.set_param_clear();
        obj_send_date.set_json(str);
        var str_param_name = "ERROR_CODE";
        var str_code = obj_send_date.get_param_value(str_param_name);

        fn_callback(str_code);
        return;
        // }, s_workmode);
    }
}

/**
 * @param {String} str_order 命令行
 * @param {Function} fn_callback 执行结束后回调函数
 */
function mc_main_presave_place(str_order, fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }

    if ("string" !== typeof str_order) {
        fn_callback(str_order);
        return;
    }
    mc_sdk_send_box_presave(str_order, function (str) {
        fn_callback(str);
    });
}

/* *************************************** HW_PLACE **************************************************************************************** */

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取发送选择框内容
 * 参数:
 *    @param {Promise<string>} str_show_option 当前界面需要显示多少个列
 *    @param {Promise<Boolean>} b_is_presave 回读按钮进入(回读按钮进入/固化或发送按钮进入 = true / false)
 *    @param {Promise<Boolean>} b_hw_relate 是否硬件相关
 *    @param {Promise<Object>} obj_hw_data 硬件连接状态实例函数
 *    @param {Promise<String>} str_cur_ctrl_card 当前主控芯片名称
 *    @param {Promise<Function>} fn_callback 回调函数(选择框内容)
 *    @param {Promise<Boolean>} b_open_sendcard 是否开启发送卡
 * 备注:
 *  错误返回:
 *          0:获取发送卡数量错误
 *          1:传入接收卡类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明,徐烁超
 *      时间 : 2020.06.15
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_send_select(str_show_option, b_is_presave, b_hw_relate, obj_hw_data, str_cur_ctrl_card, fn_callback, b_open_sendcard) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    // if ("function" !== typeof obj_hw_data.get_sendscard_cnt) {
    //     fn_callback(true, mc_set_normal_val(obj_sdk_param));
    //     return;
    // }
    if (str_cur_ctrl_card) {
        switch (str_cur_ctrl_card) {
        case "T6":
            str_cur_ctrl_card = "CNT1";
            break;
        case "多功能卡":
            str_cur_ctrl_card = "CNT2";
            break;
        case "MULTI_FUNK":
            str_cur_ctrl_card = "CNT2";
            break;
        case "FPGA":
            str_cur_ctrl_card = "CNT3";
            break;
        case "V3":
            str_cur_ctrl_card = "CNT4";
            break;
        case "MINI":
            str_cur_ctrl_card = "CNT5";
            break;
        default:
            break;
        }
    }

    var str_send_name = "MC_LANG_BTN_SCREEN_SENDING_CARD";
    var str_prot_name = "MC_LANG_RECEIVER_SEND_PORT";
    var HUB_CARD = "MC_LANG_HUB_CARD";
    var HUB_PORT = "MC_LANG_HUB_PORT";
    var str_recevier_name = "MC_LANG_RECEIVER_CARD";
    var rece_card_type = "MC_LANG_RECE_CARD_TYPE";
    var obj_sdk_param = new mc_sdk_param();

    if (!b_hw_relate) {
        mc_get_ctrlchip(function (arr_chip) {
            fn_callback(true, mc_set_normal_val(str_show_option, arr_chip, str_cur_ctrl_card, obj_sdk_param, b_open_sendcard));
        });
        return;
    }

    // eslint-disable-next-line complexity
    obj_hw_data.get_sendscard_cnt(function (ui_send_cnt) {
        if (0 >= ui_send_cnt) {
            mc_get_ctrlchip(function (arr_chip) {
                fn_callback(true, mc_set_normal_val(str_show_option, arr_chip, str_cur_ctrl_card, obj_sdk_param, b_open_sendcard));
            });
            return;
        }
        var ary_first_recvcard_idx = obj_hw_data.get_fist_recvcard_idx();
        var ui_ary_cnt;

        // 判断根据对应按钮
        if (b_is_presave) {
            // 回读
            var ary_read_param_name = [str_send_name, str_prot_name, HUB_CARD, HUB_PORT, str_recevier_name];
            var cycle_read_idx;

            switch (str_show_option) {
            case "send_card":
                cycle_read_idx = 1;
                break;
            case "send_port":
                cycle_read_idx = 2;
                break;
            case "hub_card":
                cycle_read_idx = 3;
                break;
            case "hub_port":
                cycle_read_idx = 4;
                break;
            case "rece_card":
                cycle_read_idx = 5;
                break;
            default:
                cycle_read_idx = 5;
                break;
            }

            for (var idx_read_param = 0; cycle_read_idx > idx_read_param; idx_read_param++) {
                var str_read_param_name = ary_read_param_name[idx_read_param];
                var str_fisrt_rec_idx = ary_first_recvcard_idx[idx_read_param];
                var str_param_value = "1";
                // 判断是2还是4

                if (!str_fisrt_rec_idx) {
                    var str_recevier_type = "";
                    // 获取接收卡数量

                    if (2 < ary_first_recvcard_idx.length) {
                        str_recevier_type = obj_hw_data.get_recvcard_type(ary_first_recvcard_idx[0], ary_first_recvcard_idx[1], ary_first_recvcard_idx[2], ary_first_recvcard_idx[3]);
                        ui_ary_cnt = obj_hw_data.get_recvcard_cnt(ary_first_recvcard_idx[0], ary_first_recvcard_idx[1], ary_first_recvcard_idx[2], ary_first_recvcard_idx[3]);
                    } else {
                        str_recevier_type = obj_hw_data.get_recvcard_type(ary_first_recvcard_idx[0], ary_first_recvcard_idx[1]);
                        ui_ary_cnt = obj_hw_data.get_recvcard_cnt(ary_first_recvcard_idx[0], ary_first_recvcard_idx[1]);
                    }
                    if (!str_recevier_type) {
                        str_param_value = "MC_LANG_OPTION_NULL";
                    }
                    obj_sdk_param.set_param_value(str_recevier_name, str_param_value);
                    obj_sdk_param.set_attr_val(str_recevier_name, "UI_TYPE", "OPTION");
                    obj_sdk_param.set_attr_val(str_recevier_name, "ARRAY", mc_main_hw_state_array_val(b_is_presave, ui_ary_cnt));
                    if (str_recevier_type) {
                        obj_sdk_param.set_param_value(rece_card_type, str_recevier_type);
                        obj_sdk_param.set_attr_val(rece_card_type, "UI_TYPE", "OPTION");
                        obj_sdk_param.set_attr_val(rece_card_type, "ARRAY", str_recevier_type);
                    }
                    break;
                }
                // 判断第几张卡
                if (0 === idx_read_param) {
                    ui_ary_cnt = ui_send_cnt;
                    // ui_ary_cnt = 1;
                } else if (1 === idx_read_param) {
                    ui_ary_cnt = obj_hw_data.get_port_cnt(ary_first_recvcard_idx[0]);
                } else if (2 === idx_read_param) {
                    ui_ary_cnt = obj_hw_data.get_hub_cnt(ary_first_recvcard_idx[0], ary_first_recvcard_idx[1]);
                } else if (3 === idx_read_param) {
                    ui_ary_cnt = obj_hw_data.get_hub_prot_cnt(ary_first_recvcard_idx[0], ary_first_recvcard_idx[1], ary_first_recvcard_idx[2]);
                }
                // 找出第一张接收卡的位置
                obj_sdk_param.set_param_value(str_read_param_name, (Number(ary_first_recvcard_idx[idx_read_param]) + 1).toString());
                // obj_sdk_param.set_param_value(str_read_param_name, "1");
                obj_sdk_param.set_attr_val(str_read_param_name, "UI_TYPE", "OPTION");
                obj_sdk_param.set_attr_val(str_read_param_name, "ARRAY", mc_main_hw_state_array_val(b_is_presave, ui_ary_cnt));
            }
        } else {
            // 发送固化
            var ary_param_name = [str_send_name, str_prot_name, HUB_CARD, HUB_PORT, str_recevier_name, rece_card_type];
            var cycle_idx;

            switch (str_show_option) {
            case "send_card":
                cycle_idx = 1;
                break;
            case "send_port":
                cycle_idx = 2;
                break;
            case "hub_card":
                cycle_idx = 3;
                break;
            case "hub_port":
                cycle_idx = 4;
                break;
            case "rece_card":
                cycle_idx = 5;
                break;
            default:
                cycle_idx = 5;
                break;
            }

            for (var idx_param = 0; cycle_idx > idx_param; idx_param++) {
                var str_param_name = ary_param_name[idx_param];

                obj_sdk_param.set_param_value(str_param_name, "MC_LANG_OPTION_ALL");
                obj_sdk_param.set_attr_val(str_param_name, "UI_TYPE", "OPTION");
                if (1 === idx_param) {
                    var ui_port_cnt = obj_hw_data.get_port_cnt(0);

                    obj_sdk_param.set_attr_val(str_param_name, "ARRAY", mc_main_hw_state_array_val(b_is_presave, ui_port_cnt));
                } else {
                    obj_sdk_param.set_attr_val(str_param_name, "ARRAY", "MC_LANG_OPTION_ALL");
                }
            }
            obj_sdk_param.set_attr_val(str_send_name, "ARRAY", mc_main_hw_state_array_val(b_is_presave, ui_send_cnt));
            if (5 === cycle_idx) {
                var str_rece_card_type = obj_hw_data.get_recvcard_type_all();

                str_rece_card_type = str_rece_card_type.slice(0, -1);
                var arr_rece_type = str_rece_card_type.split(",");

                if (!arr_rece_type[0]) {
                    arr_rece_type[0] = "MC_LANG_OPTION_NULL";
                    str_rece_card_type = "MC_LANG_OPTION_NULL";
                }
                obj_sdk_param.set_param_value(rece_card_type, arr_rece_type[0]);
                obj_sdk_param.set_attr_val(rece_card_type, "UI_TYPE", "OPTION");
                obj_sdk_param.set_attr_val(rece_card_type, "ARRAY", str_rece_card_type);
            }
        }
        fn_callback(false, obj_sdk_param.get_json());
        return;
    });
}


/* get_array_val */
function mc_main_hw_state_array_val(b_is_presave, ui_cnt) {
    if (!ui_cnt || 0 >= ui_cnt) {
        return "MC_LANG_OPTION_NULL";
    }
    var str_send_ary = "MC_LANG_OPTION_ALL,";

    if (b_is_presave) {
        str_send_ary = "";
    }
    for (var idx_send = 0; idx_send < ui_cnt; idx_send++) {
        str_send_ary += idx_send + 1 + ",";
    }
    return str_send_ary.substring(0, str_send_ary.length - 1);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    更新发送选择框内容
 * 参数:
 *    @param {Promise<String>} str_show_option 更新显示的项
 *    @param {Promise<Boolean>} b_is_presave 回读按钮进入(回读按钮进入/固化或发送按钮进入 = true / false)
 *    @param {Promise<Boolean>} b_hw_relate 是否硬件相关
 *    @param {Promise<String>} str_ui_json 页面数据
 *    @param {Promise<Object>} obj_hw_data 硬件连接状态实例函数
 *    @param {Promise<Function>} fn_callback 回调函数(选择框内容)
 * 备注:
 *  错误返回:
 *          0:获取发送卡数量错误
 *          1:传入接收卡类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.06.15
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_update_select(str_show_option, b_is_presave, b_hw_relate, str_ui_json, obj_hw_data, fn_callback) {
    if ("function" !== typeof fn_callback) {
        return;
    }
    if (!b_hw_relate) {
        fn_callback(false, str_ui_json);
        return;
    }

    if ("send_card" === str_show_option) {
        fn_callback(false, str_ui_json);
        return;
    }

    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_json(str_ui_json);

    var str_send_name = "MC_LANG_BTN_SCREEN_SENDING_CARD";
    var str_prot_name = "MC_LANG_RECEIVER_SEND_PORT";
    var HUB_CARD = "MC_LANG_HUB_CARD";
    var HUB_PORT = "MC_LANG_HUB_PORT";
    var str_recevier_name = "MC_LANG_RECEIVER_CARD";
    var rece_card_type = "MC_LANG_RECE_CARD_TYPE";

    // eslint-disable-next-line complexity
    obj_hw_data.get_sendscard_cnt(function (ui_send_cnt) {
        var str_recvard_type = obj_sdk_param.get_param_value(rece_card_type);

        if (0 >= ui_send_cnt) {
            mc_get_ctrlchip(function (arr_chip) {
                fn_callback(true, mc_set_normal_val(str_show_option, arr_chip, str_recvard_type, obj_sdk_param));
            });
            return;
        }
        var b_if_all = false;
        var obj_param_res = new mc_sdk_param();
        // 获取存入的值
        var str_send_idx = obj_sdk_param.get_param_value(str_send_name);
        var str_port_idx = obj_sdk_param.get_param_value(str_prot_name);
        var str_hub_idx = obj_sdk_param.get_param_value(HUB_CARD);
        var str_hub_port_idx = obj_sdk_param.get_param_value(HUB_PORT);
        var str_recvard_idx = obj_sdk_param.get_param_value(str_recevier_name);
        var str_rece_type = obj_sdk_param.get_param_value(rece_card_type);

        if (!str_send_idx) {
            fn_callback(true, obj_param_res.get_json());
            return;
        }

        // 发送卡
        if ("MC_LANG_OPTION_ALL" === str_send_idx) {
            b_if_all = true;
            obj_param_res.set_attr_val(str_send_name, "ARRAY", obj_sdk_param.get_attr_val(str_send_name, "ARRAY"));
        } else {
            obj_param_res.set_attr_val(str_send_name, "ARRAY", mc_main_hw_state_array_val(b_is_presave, ui_send_cnt));
        }
        obj_param_res.set_param_value(str_send_name, str_send_idx);
        obj_param_res.set_attr_val(str_send_name, "UI_TYPE", "OPTION");

        // 发送卡端口
        obj_param_res.set_param_value(str_prot_name, str_port_idx);
        obj_param_res.set_attr_val(str_prot_name, "UI_TYPE", "OPTION");
        if (b_if_all) {
            obj_param_res.set_attr_val(str_prot_name, "ARRAY", obj_sdk_param.get_attr_val(str_prot_name, "ARRAY"));
        } else {
            var ui_port_cnt = obj_hw_data.get_port_cnt((Number(str_send_idx) - 1));

            obj_param_res.set_attr_val(str_prot_name, "ARRAY", mc_main_hw_state_array_val(b_is_presave, ui_port_cnt));
        }

        if ("MC_LANG_OPTION_ALL" === str_port_idx) {
            b_if_all = true;
        }

        // 只显示到发送卡网口
        if ("send_port" === str_show_option) {
            fn_callback(false, obj_param_res.get_json());
            return;
        }

        var ui_hub_cnt = obj_hw_data.get_hub_cnt((Number(str_send_idx) - 1), (Number(str_port_idx) - 1));
        // 判断是否有hub卡

        if (0 < ui_hub_cnt || str_show_option) {
            // 判断hub卡
            if (b_if_all) {
                // if ("undefined" === typeof str_hub_idx) {
                if (!str_hub_idx) {
                    obj_param_res.set_param_value(HUB_CARD, "MC_LANG_OPTION_ALL");
                    obj_param_res.set_attr_val(HUB_CARD, "ARRAY", "MC_LANG_OPTION_ALL");
                } else {
                    obj_param_res.set_param_value(HUB_CARD, str_hub_idx);
                    obj_param_res.set_attr_val(HUB_CARD, "ARRAY", obj_sdk_param.get_attr_val(HUB_CARD, "ARRAY"));
                }
            } else {
                // 排除上次没有hub的情况
                if (!str_hub_idx) {
                    if (b_is_presave) {
                        str_hub_idx = "1";
                    } else {
                        str_hub_idx = "MC_LANG_OPTION_ALL";
                    }
                }
                obj_param_res.set_param_value(HUB_CARD, str_hub_idx);
                obj_param_res.set_attr_val(HUB_CARD, "ARRAY", mc_main_hw_state_array_val(b_is_presave, ui_hub_cnt));
            }
            obj_param_res.set_attr_val(HUB_CARD, "UI_TYPE", "OPTION");

            // 只显示到hub卡
            if ("hub_card" === str_show_option) {
                fn_callback(false, obj_param_res.get_json());
                return;
            }

            if ("MC_LANG_OPTION_ALL" === str_hub_idx) {
                b_if_all = true;
            }

            // 判断hub卡端口
            var ui_hub_port_cnt = obj_hw_data.get_hub_prot_cnt((Number(str_send_idx) - 1), (Number(str_port_idx) - 1), (Number(str_hub_idx) - 1));

            if (b_if_all) {
                obj_param_res.set_attr_val(HUB_PORT, "ARRAY", obj_sdk_param.get_attr_val(HUB_PORT, "ARRAY"));
                if (!str_hub_port_idx) {
                    obj_param_res.set_param_value(HUB_PORT, "MC_LANG_OPTION_ALL");
                    obj_param_res.set_attr_val(HUB_PORT, "ARRAY", "MC_LANG_OPTION_ALL");
                } else {
                    obj_param_res.set_param_value(HUB_PORT, str_hub_port_idx);
                    obj_param_res.set_attr_val(HUB_PORT, "ARRAY", obj_sdk_param.get_attr_val(HUB_PORT, "ARRAY"));
                }
            } else {
                if (0 < ui_hub_port_cnt) {
                    if (!str_hub_port_idx) {
                        str_hub_port_idx = "1";
                    }

                    obj_param_res.set_param_value(HUB_PORT, str_hub_port_idx);
                    obj_param_res.set_attr_val(HUB_PORT, "ARRAY", mc_main_hw_state_array_val(b_is_presave, ui_hub_port_cnt));
                }
            }
            obj_param_res.set_attr_val(HUB_PORT, "UI_TYPE", "OPTION");
            if ("MC_LANG_OPTION_ALL" === str_hub_port_idx) {
                b_if_all = true;
            }
        } else {
            if (b_if_all) {
                obj_param_res.set_param_value(HUB_CARD, "MC_LANG_OPTION_ALL");
                obj_param_res.set_attr_val(HUB_CARD, "UI_TYPE", "OPTION");
                obj_param_res.set_attr_val(HUB_CARD, "ARRAY", "MC_LANG_OPTION_ALL");
                obj_param_res.set_param_value(HUB_PORT, "MC_LANG_OPTION_ALL");
                obj_param_res.set_attr_val(HUB_PORT, "UI_TYPE", "OPTION");
                obj_param_res.set_attr_val(HUB_PORT, "ARRAY", "MC_LANG_OPTION_ALL");
            }
        }

        var str_recevier_type = "";
        var ui_rec_cnt = 0;
        // 判断有没有hub卡以获取对应的接收卡数量

        if (b_if_all) {
            obj_param_res.set_param_value(str_recevier_name, "MC_LANG_OPTION_ALL");
            obj_param_res.set_attr_val(str_recevier_name, "ARRAY", "MC_LANG_OPTION_ALL");

            var str_rece_card_type = obj_hw_data.get_recvcard_type_all();

            str_rece_card_type = str_rece_card_type.slice(0, -1);
            if (!str_rece_card_type) {
                obj_param_res.set_param_value(rece_card_type, "MC_LANG_OPTION_NULL");
                obj_param_res.set_attr_val(rece_card_type, "ARRAY", "MC_LANG_OPTION_NULL");
            } else {
                if (str_rece_type) {
                    if ("-1" !== str_rece_type.indexOf(obj_sdk_param.get_param_value(rece_card_type))) {
                        obj_param_res.set_param_value(rece_card_type, str_rece_type);
                    } else {
                        obj_param_res.set_param_value(rece_card_type, str_rece_card_type.split(",")[0]);
                    }
                } else {
                    obj_param_res.set_param_value(rece_card_type, str_rece_card_type.split(",")[0]);
                }
                // 接收卡类型
                obj_param_res.set_attr_val(rece_card_type, "ARRAY", str_rece_card_type);
            }
            obj_param_res.set_attr_val(rece_card_type, "UI_TYPE", "OPTION");
        } else {
            if (
                0 >= ui_hub_cnt ||
                0 >= ui_hub_port_cnt
            ) {
                str_recevier_type = obj_hw_data.get_recvcard_type((Number(str_send_idx) - 1), (Number(str_port_idx) - 1));
                ui_rec_cnt = obj_hw_data.get_recvcard_cnt((Number(str_send_idx) - 1), (Number(str_port_idx) - 1));
            } else {
                str_recevier_type = obj_hw_data.get_recvcard_type((Number(str_send_idx) - 1), (Number(str_port_idx) - 1), (Number(str_hub_idx) - 1), (Number(str_hub_port_idx) - 1));
                ui_rec_cnt = obj_hw_data.get_recvcard_cnt((Number(str_send_idx) - 1), (Number(str_port_idx) - 1), (Number(str_hub_idx) - 1), (Number(str_hub_port_idx) - 1));
            }

            var str_rec_val = "";
            // 判断当前最新是否有接收卡

            if (0 >= ui_rec_cnt) {
                str_rec_val = "MC_LANG_OPTION_NULL";
            } else if ("MC_LANG_OPTION_NULL" !== str_recvard_idx && (Number(str_recvard_idx) <= ui_rec_cnt || "MC_LANG_OPTION_ALL" === str_recvard_idx)) {
                str_rec_val = str_recvard_idx;
            } else {
                str_rec_val = "1";
            }
            obj_param_res.set_attr_val(str_recevier_name, "ARRAY", mc_main_hw_state_array_val(b_is_presave, ui_rec_cnt));
            obj_param_res.set_param_value(str_recevier_name, str_rec_val);

            // 接收卡类型 先判断最新是否存在此卡
            if ("MC_LANG_OPTION_NULL" !== str_recevier_type && "" !== str_recevier_type) {
                // 判断当前选择的是否存在
                if (str_rece_type) {
                    if ("-1" !== str_rece_type.indexOf(obj_sdk_param.get_param_value(rece_card_type))) {
                        obj_param_res.set_param_value(rece_card_type, str_rece_type);
                    } else {
                        obj_param_res.set_param_value(rece_card_type, str_recevier_type.split(",")[0]);
                    }
                } else {
                    obj_param_res.set_param_value(rece_card_type, str_recevier_type.split(",")[0]);
                }
                obj_param_res.set_attr_val(rece_card_type, "UI_TYPE", "OPTION");
                obj_param_res.set_attr_val(rece_card_type, "ARRAY", str_recevier_type);
            }
        }
        obj_param_res.set_attr_val(str_recevier_name, "UI_TYPE", "OPTION");


        fn_callback(false, obj_param_res.get_json());
    });
}

function mc_set_normal_val(str_show_option, arr_chip, str_cur_ctrl_card, obj_sdk_param, b_open_sendcard) {
    if (b_open_sendcard) {
        obj_sdk_param.set_param_value("MC_LANG_BTN_SCREEN_SENDING_CARD", "1");
        obj_sdk_param.set_attr_val("MC_LANG_BTN_SCREEN_SENDING_CARD", "UI_TYPE", "STEP_EDIT");
        obj_sdk_param.set_attr_val("MC_LANG_BTN_SCREEN_SENDING_CARD", "STEP", "1");
        obj_sdk_param.set_attr_val("MC_LANG_BTN_SCREEN_SENDING_CARD", "MIN_VAL", "1");
        obj_sdk_param.set_attr_val("MC_LANG_BTN_SCREEN_SENDING_CARD", "VAL_TYPE", "uint");
    }

    // if ("send_card" === str_show_option) {
    //     return obj_sdk_param.get_json();
    // }

    obj_sdk_param.set_param_value("MC_LANG_RECEIVER_SEND_PORT", "1");
    obj_sdk_param.set_attr_val("MC_LANG_RECEIVER_SEND_PORT", "UI_TYPE", "STEP_EDIT");
    obj_sdk_param.set_attr_val("MC_LANG_RECEIVER_SEND_PORT", "STEP", "1");
    obj_sdk_param.set_attr_val("MC_LANG_RECEIVER_SEND_PORT", "MIN_VAL", "1");
    obj_sdk_param.set_attr_val("MC_LANG_RECEIVER_SEND_PORT", "VAL_TYPE", "uint");

    if ("send_port" === str_show_option) {
        return obj_sdk_param.get_json();
    }

    obj_sdk_param.set_param_value("MC_LANG_HUB_CARD", "1");
    obj_sdk_param.set_attr_val("MC_LANG_HUB_CARD", "UI_TYPE", "STEP_EDIT");
    obj_sdk_param.set_attr_val("MC_LANG_HUB_CARD", "STEP", "1");
    obj_sdk_param.set_attr_val("MC_LANG_HUB_CARD", "MIN_VAL", "1");
    obj_sdk_param.set_attr_val("MC_LANG_HUB_CARD", "VAL_TYPE", "uint");

    if ("hub_card" === str_show_option) {
        return obj_sdk_param.get_json();
    }

    obj_sdk_param.set_param_value("MC_LANG_HUB_PORT", "1");
    obj_sdk_param.set_attr_val("MC_LANG_HUB_PORT", "UI_TYPE", "STEP_EDIT");
    obj_sdk_param.set_attr_val("MC_LANG_HUB_PORT", "STEP", "1");
    obj_sdk_param.set_attr_val("MC_LANG_HUB_PORT", "MIN_VAL", "1");
    obj_sdk_param.set_attr_val("MC_LANG_HUB_PORT", "VAL_TYPE", "uint");

    obj_sdk_param.set_param_value("MC_LANG_RECEIVER_CARD", "1");
    obj_sdk_param.set_attr_val("MC_LANG_RECEIVER_CARD", "UI_TYPE", "STEP_EDIT");
    obj_sdk_param.set_attr_val("MC_LANG_RECEIVER_CARD", "STEP", "1");
    obj_sdk_param.set_attr_val("MC_LANG_RECEIVER_CARD", "MIN_VAL", "1");
    obj_sdk_param.set_attr_val("MC_LANG_RECEIVER_CARD", "VAL_TYPE", "uint");

    obj_sdk_param.set_param_value("MC_LANG_RECE_CARD_TYPE", str_cur_ctrl_card ? str_cur_ctrl_card : "CNT1");
    obj_sdk_param.set_attr_val("MC_LANG_RECE_CARD_TYPE", "UI_TYPE", "OPTION");
    var arr_card_type = [];

    for (var idx = 0; idx < arr_chip.length; idx++) {
        if ("T6" === arr_chip[idx]) {
            arr_card_type.push("CNT1");
            continue;
        }
        if ("FPGA" === arr_chip[idx]) {
            arr_card_type.push("CNT3");
            continue;
        }
        if ("V3" === arr_chip[idx]) {
            arr_card_type.push("CNT4");
            continue;
        }
        if ("MINI" === arr_chip[idx]) {
            arr_card_type.push("CNT5");
            continue;
        }
    }

    arr_card_type.push("CNT2");

    obj_sdk_param.set_attr_val("MC_LANG_RECE_CARD_TYPE", "ARRAY", arr_card_type.toString());

    return obj_sdk_param.get_json();
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    加载箱体文件数据
 * 参数:
 *    @param {Promise<String>} str_date 页面字串
 *    @param {Promise<Array>} ary_box_data 箱体信息
 *    @param {Promise<Array>} ary_mod_data 模组信息
 *    @param {Promise<Boolean>} b_type 判断当前进入的界面
 * 返回:
 *    @returns {Promise<boolean>} 执行结果
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.06.22
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_after_onload(str_date, ary_box_data, ary_mod_data, b_type) {
    mc_loading_wait();
    var str_load_txt = str_date;

    if ("string" !== typeof str_load_txt || 0 === str_load_txt.length) {
        mc_main_alert_popout("MC_LANG_POPOUT_FILE_COT");
        mc_loading_wait_remove();
        return false;
    }
    var before_load_boxdata_len = ary_box_data.length + 1;
    var str_box_name = mc_main_load_msg(str_load_txt, ary_box_data, ary_mod_data);

    if ("string" !== typeof str_box_name) {
        mc_main_alert_popout("MC_LANG_SAVE_ERROR_" + str_box_name);
        mc_loading_wait_remove();
        return false;
    }

    var ui_box_index = 0;
    var save_box_data = ary_box_data;
    var str_box_json = "";

    // 创建侧边箱体
    if (before_load_boxdata_len < ary_box_data.length) {
        // 需要创建多个
        var ui_create = ary_box_data.length - before_load_boxdata_len - 1;

        for (var idx = 0; idx < ui_create; idx++) {
            ary_box_data = save_box_data.slice(0, before_load_boxdata_len + ui_box_index);
            str_box_json = mc_layout_get_box_basic(ary_box_data[before_load_boxdata_len +
                ui_box_index].name, ary_box_data, ary_mod_data);

            parent.get_box_info(true, str_box_json);
            ui_box_index++;
        }
    } else {
        var box_name = ary_box_data[ary_box_data.length - 1].name;

        str_box_json = mc_layout_get_box_basic(box_name, ary_box_data, ary_mod_data);
        parent.get_box_info(true, str_box_json);
    }

    // 创建侧边模组
    parent.get_mod_info(true);
    mc_loading_wait_remove();
    if (!b_type) {
        mc_main_alert_popout("MC_LANG_POPOUT_LOAD_SUCCESS");
    }
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    判断当前箱体是否使用多个模组，若使用多个模组弹层页面选择查看模组
 * 参数:
 *    @param { Promise<String> } str_box_name 当前箱体名称
 *    @param { Promise<Array> } ary_use_mod 当前使用模组名数组ARY_USE_MOD_NAME
 *    @param { Promise<Function> }  fn_callback 回调函数
 * 返回：
 *    @return { Promise<Function> }
 *     fn_callback(true) 参数有误/单个模组
 *     fn_callback(false) 多个模组
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.6.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_box_main_select_mod(str_box_name, ary_use_mod, fn_callback) {
    if ("string" !== typeof str_box_name || 0 === str_box_name.length || !Array.isArray(ary_use_mod) || 0 === ary_use_mod.length) {
        return fn_callback(true);
    }
    var ary_use_mod_name = [];

    for (var idx = 0; idx < ary_use_mod.length; idx++) {
        var obj_item = ary_use_mod[idx];
        var str_name_data = obj_item.name;

        if (str_box_name === str_name_data.toLocaleUpperCase()) {
            ary_use_mod_name = obj_item.use_mod_name;
            break;
        }
    }

    if (1 < ary_use_mod_name.length) {
        // 弹层选择查看模组
        var str_url = "./pages/check_mod/check_mod.html";
        var obj_popout = {
            icon: "icon-mod-wizard",
            title: "MC_LANG_SELECT_VIEW_MOD",
            url: str_url,
            area: ["300px", "100%"],
            skin: "layui-anim layui-anim-rl layui-layer-adminRight level_nd set_max_width_six_hund set_min_width"
        };

        // parent.mc_iframe_popout(obj_popout);
        parent.G_OBJ_ROUTER_PAGE.set_popup_layer_msg(obj_popout);
        parent.G_OBJ_ROUTER_PAGE.open_popup_layer();
        return fn_callback(false);
    }
    return fn_callback(true);
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取控制芯片列表
 * 参数:
 *    @param {Promise<string>} fun_callback 传入回调函数
 * 返回：
 *    控制芯片列表数组
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.22
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_ctrlchip(fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var obj_param_req = new mc_sdk_param();

    obj_param_req.set_param_clear();
    obj_param_req.set_func("CTRLCHIP_LIST");
    obj_param_req.set_cmd("GET_PARAM");

    $.post("/access_shell", obj_param_req.get_json(), function (rsp, status) {
        if ("success" !== status) {
            return;
        }

        var obj_param_rsp = new mc_sdk_param();

        obj_param_rsp.set_json(rsp);

        var ui_ctrlchip_cnt = obj_param_rsp.get_param_cnt();
        var ary_chip_name = [];

        for (var idx_chip = 0; idx_chip < ui_ctrlchip_cnt; idx_chip++) {
            var str_param_name = obj_param_rsp.get_param_name(idx_chip);

            if ("ERROR_CODE" === str_param_name.toUpperCase()) {
                continue;
            }
            var str_chip_name = obj_param_rsp.get_param_value(str_param_name);

            if ("string" !== typeof str_chip_name || 0 === str_chip_name.length) {
                continue;
            }
            ary_chip_name.push(str_chip_name);
        }

        fun_callback(ary_chip_name);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    下发箱体连接的模组信息
 * 参数:
 *    @param {Promise<Array>} arr_use_mod 使用的模组
 *    @param {Promise<Array>} ary_mod_data 模组数据
 *    @param {Promise<fun>} fun_callback 传入回调函数
 * 返回：
 *    控制芯片列表数组
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.3.05
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_set_mod(arr_use_mod, ary_mod_data, fun_callback) {
    var arr_mod_set_data = [];
    var arr_mod_set_name = [];

    for (var idx_mod = 0; idx_mod < ary_mod_data.length; idx_mod++) {
        for (var idx_mod_use = 0; idx_mod_use < arr_use_mod.length; idx_mod_use++) {
            if (ary_mod_data[idx_mod].name === arr_use_mod[idx_mod_use]) {
                arr_mod_set_data.push(ary_mod_data[idx_mod].data.mc_util_mod_get_xml());
                arr_mod_set_name.push(arr_use_mod[idx_mod_use]);
                continue;
            }
        }
    }

    var ui_times = 0;
    // 递归下发模组

    mc_set(ui_times);
    function mc_set(ui) {
        if (ui < arr_mod_set_data.length) {
            mc_height_set_mod_file(arr_mod_set_data[ui_times], arr_mod_set_name[ui_times], function () {
                mc_set(++ui_times);
            });
        } else {
            fun_callback();
        }
    }
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    下发模组信息
 * 参数:
 *    @param {Promise<string>}str_module_xml_txt 页面模组信息
 *    @param {Promise<string>}str_mod_name 模组名称
 *    @param {Promise<Function>}fun_callback 回调函数
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.3.5
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_height_set_mod_file(str_module_xml_txt, str_mod_name, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_module_xml_txt || 0 >= str_module_xml_txt.length) {
        fun_callback();
        return;
    }
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("MOD_FILE");
    obj_sdk_param.set_cmd("SET_PARAM");
    // str_mod_text
    obj_sdk_param.set_param_value(str_mod_name, str_module_xml_txt);
    obj_sdk_param.set_attr_val(str_mod_name, "FILE_OPT", "SET");
    $.post("/access_shell", obj_sdk_param.get_json(), function (_response, status) {
        if ("success" !== status) {
            return;
        }
        fun_callback();
    }, "text");
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    读取 色域校正硬件参数
 * 参数:
 *    @param {Promise<String>} str_ctrl 接收卡名称
 *    @param {Promise<Array>} arr 色域界面参数

 *    @param {Promise<Function>} fun_callback 回调
 * 返回：
//  *   @returns {Promise<String>} str_error_date 错误码
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.04.30
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_hw_gamut(str_ctrl, arr, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }

    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("GET_PARAM");
    obj_req.set_func("RECVCARD_GAMUT");
    obj_req.set_param_value(str_ctrl);

    var str_list = "(" + arr[0] + ":" + arr[4] + ":" + arr[7] + ":" + arr[1] + ":" + arr[3] + ":" + arr[8] + ":" + arr[2] + ":" + arr[5] + ":" + arr[6] + ")";

    obj_req.set_attr_val(str_ctrl, "GAMUT_EXP", str_list);

    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var str_data = "";
        var obj_res = new mc_sdk_param();

        obj_res.set_json(result);
        // var str_error_date = obj_res.get_param_value("ERROR_CODE");
        var ui_param_cnt = obj_res.get_param_cnt();

        for (var idx = 0; idx < ui_param_cnt; idx++) {
            var str_param_name = obj_res.get_param_name(idx);

            if ("ERROR_CODE" === str_param_name) {
                continue;
            }

            str_data = obj_res.get_param_value(str_param_name);
            obj_res.set_json(str_data);
        }


        fun_callback(obj_res);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    合并两个device配置
 * 参数:
 *    @param {Promise<object>} obj_first 接收卡配置对象
 *    @param {Promise<object>} obj_second 接收卡配置对象
 * 返回：
//  *   @returns {Promise<object>} obj_retrun 合成对象
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.04.30
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_merge_device(obj_first, obj_second) {
    var obj_retrun = new mc_sdk_param();

    obj_retrun.set_json(obj_second.get_json());

    var ui_param_cnt = obj_retrun.get_param_cnt();
    // 存储排序 从0开始
    var id_cnt = ui_param_cnt;

    var ui_into_param_cnt = obj_first.get_param_cnt();

    for (var idx = 0; idx < ui_into_param_cnt; idx++) {
        var str_into_param_name = obj_first.get_param_name(idx);
        var str_into_param_val = obj_first.get_param_value(str_into_param_name);

        if (!str_into_param_val) {
            continue;
        }

        var str_order = "";

        // 暂时设置数量在100个以内
        if (0 < id_cnt && 10 > id_cnt) {
            str_order = "000" + id_cnt;
        } else if (10 <= id_cnt && 100 > id_cnt) {
            str_order = "00" + id_cnt;
        }

        obj_retrun.set_param_value(str_order, str_into_param_val);

        var ui_into_attr_cnt = obj_first.get_attr_cnt(str_into_param_name);

        for (var idx_attr = 0; idx_attr < ui_into_attr_cnt; idx_attr++) {
            var str_into_attr_name = obj_first.get_attr_name(str_into_param_name, idx_attr);
            var str_into_attr_val = obj_first.get_attr_val(str_into_param_name, str_into_attr_name);

            if (!str_into_attr_val) {
                continue;
            }

            obj_retrun.set_attr_val(str_order, str_into_attr_name, str_into_attr_val);
        }
        id_cnt += 1;
    }


    return obj_retrun;
}
